### **1. What is a Reconnaissance Attack?**

- A **reconnaissance attack** is an attempt to gather information about a target before launching a more intrusive attack.
- Often considered a **preamble or phase of an attack**.

---

### **2. Tools and Techniques Used in Reconnaissance Attacks**

#### **a) Gathering Public Information**

- Attackers use standard networking tools, such as:
    - **dig**, **nslookup**, and **whois**: To gather public DNS information about a target network.
    - **DNS queries**: Reveal ownership of a domain and assigned addresses.

#### **b) Ping Sweeps**

- Identifies **live hosts** in the target environment.

#### **c) Port Scanning**

- Probes live hosts to determine:
    - **Open ports** and associated application protocols.
    - **Operating systems**, **MAC addresses**, and **software versions**.
- Common tools:
    - **nmap**: Scans all well-known ports and provides a list of running services.

---

### **3. Characteristics of Port Scanning**

#### **a) Rapid or Sequential Scanning**

- Easy to detect by security analysts through:
    - Monitoring firewall logs or other security tools.
    - Observing activity targeting many ports on the same host in a short period.

#### **b) Stealth Techniques**

- Attackers avoid detection by:
    - Using **slow, random scans**.
    - Employing advanced tools to evade detection.

---

### **4. Vulnerability Scanning**

#### **a) Tools**

- Attackers and security professionals use tools like:
    - **Nessus** and **OpenVAS**: To locate vulnerabilities in target hosts.

#### **b) Ethical Use**

- Authorized security administrators can use vulnerability scanners to:
    - Patch vulnerabilities before they are exploited.
- **Important Note**: Unauthorized use of vulnerability scanners violates security policies.

---

### **5. Exploiting Vulnerabilities**

- After reconnaissance, attackers exploit:
    - **Known vulnerabilities of open services** (from port scans).
    - **Operating system and software weaknesses**.

---

### **6. Key Security Countermeasures**

- Use **intrusion prevention systems (IPSs)** to detect stealth scans.
- Monitor **firewall logs** and other activity logs for unusual patterns.
- Proactively perform vulnerability scanning (with authorization) to address weaknesses.